# -*- coding: utf-8 -*-
"""Untitled27.ipynb

Automatically generated by Colab.

Original file is located at
    https://colab.research.google.com/drive/1B9SZoZrU-cBPcNbOTgAVuCVQKlpso2-R
"""

# -*- coding: utf-8 -*-
"""
Main script to run Experiment 3: Scalability Analysis.

This script defines parameters for Experiment 3, imports the necessary
functions from matrix_approximation_lib_exp3, runs the experiment,
saves the results to a JSON file, and generates plots.
"""

import time
import json
import os
import numpy as np # For np.float32, np.float64, np.number in JSON serialization
import traceback

# Import from the library file
try:
    from matrix_product_approximations_exp3 import (
        run_experiment_3_scalability,
        plot_experiment_3_scalability,
        ADAPTED_EXPERIMENT_STYLES
    )
except ImportError:
    print("ERROR: Could not import from matrix_approximation_lib_exp3.py.")
    print("Ensure matrix_approximation_lib_exp3.py is in the same directory or Python path.")
    exit()

# ==============================================================================
# MAIN EXECUTION BLOCK (EXPERIMENT 3)
# ==============================================================================
if __name__ == "__main__":
    print("\n\n--- Running Experiment 3: Scalability Analysis (No SVD/Optimal v_k*) ---")

    # --- Parameters for Experiment 3 ---
    N_VALUES_EXP3_RUN = [200, 400, 800, 1500, 2500]
    M_DIM_EXP3_RUN = 50
    P_DIM_EXP3_RUN = 30
    K_RATIO_EXP3_RUN = 0.2  # k will be k_ratio * n
    N_TRIALS_EXP3_RUN = 3   # Number of trials for randomized algorithms
    BASE_SEED_EXP3_RUN = 2025
    DISTRIBUTION_TYPE_EXP3_RUN = 'gaussian' # Options: 'gaussian', 'uniform'
    # --- End of Parameters ---

    print(f"\nParameters for this run (Exp 3):")
    print(f"  n values: {N_VALUES_EXP3_RUN}")
    print(f"  m, p: {M_DIM_EXP3_RUN}, {P_DIM_EXP3_RUN}")
    print(f"  k ratio (k/n): {K_RATIO_EXP3_RUN}")
    print(f"  Number of trials for random algos: {N_TRIALS_EXP3_RUN}")
    print(f"  Matrix distribution: {DISTRIBUTION_TYPE_EXP3_RUN.capitalize()}")
    print(f"  Base seed: {BASE_SEED_EXP3_RUN}")

    start_time_exp3_total = time.time()
    exp3_collected_results = run_experiment_3_scalability(
        n_values=N_VALUES_EXP3_RUN,
        m_dim_exp=M_DIM_EXP3_RUN,
        p_dim_exp=P_DIM_EXP3_RUN,
        k_ratio_exp=K_RATIO_EXP3_RUN,
        n_trials_exp=N_TRIALS_EXP3_RUN,
        base_seed_exp=BASE_SEED_EXP3_RUN,
        matrix_dist_type_exp=DISTRIBUTION_TYPE_EXP3_RUN
    )
    end_time_exp3_total = time.time()
    print(f"\n--- Experiment 3 Data Collection (Dist: {DISTRIBUTION_TYPE_EXP3_RUN.capitalize()}) Finished in {end_time_exp3_total - start_time_exp3_total:.2f} seconds ---")

    # Ensure results directory exists (it's also created in the lib, but good practice here too)
    os.makedirs("results", exist_ok=True)
    results_filename = os.path.join(
        "results",
        f"Exp3_Scalability_{DISTRIBUTION_TYPE_EXP3_RUN}_m{M_DIM_EXP3_RUN}_p{P_DIM_EXP3_RUN}_kratio{str(K_RATIO_EXP3_RUN).replace('.','pt')}_results.json"
    )
    try:
        with open(results_filename, 'w') as f:
            # Make results JSON serializable (convert numpy types to Python types)
            serializable_results = {}
            for n_key, data_val in exp3_collected_results.items():
                serializable_data_val = {}
                for k_inner, v_inner in data_val.items():
                    if isinstance(v_inner, dict): # For 'results' and 'times' dicts
                        serializable_data_val[k_inner] = {
                            key_sub: (float(val_sub) if isinstance(val_sub, (np.float32, np.float64, np.number, np.bool_)) else val_sub)
                            for key_sub, val_sub in v_inner.items()
                        }
                    elif isinstance(v_inner, (np.float32, np.float64, np.number, np.bool_)):
                        serializable_data_val[k_inner] = float(v_inner)
                    else:
                        serializable_data_val[k_inner] = v_inner
                serializable_results[str(n_key)] = serializable_data_val
            json.dump(serializable_results, f, indent=4)
        print(f"Saved Experiment 3 results to: {results_filename}")
    except Exception as e:
        print(f"Error saving results to JSON for Experiment 3: {e}")
        traceback.print_exc()


    print("\n--- Generating Plots for Experiment 3 ---")
    if exp3_collected_results:
        try:
            # Ensure plots directory exists
            os.makedirs("plots", exist_ok=True)
            plot_experiment_3_scalability(
                exp_results_data=exp3_collected_results,
                styles_to_use=ADAPTED_EXPERIMENT_STYLES,
                plot_filename_prefix="Exp3_Scalability_Final" # Updated prefix
            )
        except Exception as e_plot:
            print(f"ERROR: Failed Experiment 3 plot generation: {e_plot}")
            traceback.print_exc()
    else:
        print("Skipping plot generation: Experiment 3 returned no results.")

    print(f"\n--- Experiment 3 (Dist: {DISTRIBUTION_TYPE_EXP3_RUN.capitalize()}) Fully Finished ---")
    print("\n--- All Script Operations Completed ---")

